/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.entity.data.TextBlock;
import noppes.npcs.util.Util;

public class TextBlockClient
extends TextBlock {
    public int color = new Color(0xE0E0E0).getRGB();
    private String name;
    private ICommandSender sender;
    private final Style style = new Style();
    public Entity entity;
    public String text;

    public TextBlockClient(ICommandSender senderIn, String text, int lineWidth, int colorIn, Entity entity, Object ... obs) {
        this(text, lineWidth, false, entity, obs);
        this.color = colorIn;
        this.sender = senderIn;
    }

    public TextBlockClient(String totalText, int lineWidth, boolean mcFont, Entity entityIn, Object ... obs) {
        this.entity = entityIn;
        this.text = NoppesStringUtils.formatText(totalText, obs);
        this.text = this.text.replace("\n", " \n ");
        this.text = this.text.replace("\r", " \r ");
        this.resetWidth(lineWidth, mcFont);
    }

    public TextBlockClient(String nameIn, String text, int lineWidth, int colorIn, Entity entity, Object ... obs) {
        this(text, lineWidth, false, entity, obs);
        this.color = colorIn;
        this.name = nameIn;
    }

    private void addLine(String text) {
        TextComponentString line = new TextComponentString(text);
        line.func_150255_a(this.style);
        this.lines.add(line);
    }

    public String getName() {
        if (this.sender != null) {
            return this.sender.func_70005_c_();
        }
        return this.name;
    }

    public void resetWidth(int lineWidth, boolean mcFont) {
        String line = "";
        List<String> tempList = this.getStrings();
        String[] words = tempList.toArray(new String[0]);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        String color = "\u00a7r";
        for (String word : words) {
            int widthLine;
            char c;
            if (word.isEmpty()) continue;
            if (word.length() == 1 && ((c = word.charAt(0)) == '\r' || c == '\n')) {
                this.addLine(color + line);
                color = Util.instance.getLastColor(color, line);
                line = "";
                continue;
            }
            String newLine = line + word;
            int n = widthLine = mcFont ? font.func_78256_a(newLine) : ClientProxy.Font.width(newLine);
            if (widthLine > lineWidth && !line.isEmpty()) {
                this.addLine(color + line);
                color = Util.instance.getLastColor(color, line);
                line = word;
                continue;
            }
            line = newLine;
        }
        if (!line.isEmpty()) {
            this.addLine(color + line);
        }
    }

    private List<String> getStrings() {
        String tempText = this.text;
        ArrayList<String> tempList = new ArrayList<String>();
        while (true) {
            int fm = -1;
            String corr = "\t\n ()[]{}.,<>:;+-*\\/\"";
            for (int i = 0; i < corr.length(); ++i) {
                int found = tempText.indexOf("" + corr.charAt(i));
                if (found == -1 || found >= fm && fm != -1) continue;
                fm = found;
            }
            if (fm < 0) break;
            String subWorld = tempText.substring(0, fm + 1);
            tempList.add(subWorld);
            tempText = tempText.substring(fm + 1);
        }
        tempList.add(tempText);
        return tempList;
    }
}

